/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build.xml;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.DrawingHistoryEntry;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterItemIdentifierTableLogo7;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.hardware.Logo7;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileFromXmlLogo;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileParameterFromXmlUDF;
import DE.siemens.ad.logo.util.ElementCodeBlock;
import DE.siemens.ad.logo.util.EncryptAndDecrypt;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;

public class CompileFromXmlUDF
extends CompileFromXmlLogo {
    protected Hashtable fUDFStorer;

    public WiringDiagram compile(Hardware hw, Document document) {
        this.fDocument = document;
        this.fHardware = (Logo)hw;
        this.fUDFStorer = new Hashtable();
        ((CompileParameterFromXmlUDF)this.fHardware.getParameterCompiler()).setfUDFStorer(this.fUDFStorer);
        Element topUdfNode = (Element)this.fDocument.selectSingleNode("/LOGO/UDFBlock");
        this.fWiringDiagram = new WiringDiagramUDF(hw);
        UDFBlock udfBlock = ((WiringDiagramUDF)this.fWiringDiagram).getUDFBlock();
        udfBlock.initInOutDeputyArray(Integer.valueOf(topUdfNode.attributeValue("inCounter")), Integer.valueOf(topUdfNode.attributeValue("outCounter")));
        this.parseUDF(udfBlock, topUdfNode);
        ((WiringDiagramUDF)this.fWiringDiagram).setUDFBlock(udfBlock);
        this.fUDFStorer.clear();
        this.loadProperties(this.fWiringDiagram, document.getRootElement());
        return this.fWiringDiagram;
    }

    public UDFBlock compileUDFBlock(Hardware hw, Document document) {
        this.compile(hw, document);
        UDFBlock block = ((WiringDiagramUDF)this.fWiringDiagram).initUDFBlock4UseMode();
        this.fWiringDiagram = null;
        return block;
    }

    protected void parseUDF(UDFBlock udfBlock, Element outerUDFBlockNode) {
        Element blocksNode = outerUDFBlockNode.element("Blocks");
        Iterator udfIterator = blocksNode.elementIterator("UDFBlock");
        UDFBlock innerUDF = null;
        while (udfIterator.hasNext()) {
            Element innerUDFNode = (Element)udfIterator.next();
            int udfNumber = Integer.valueOf(innerUDFNode.attributeValue("blockNumber"));
            innerUDF = this.getUDFBlock(udfNumber, Integer.valueOf(innerUDFNode.attributeValue("inCounter")), Integer.valueOf(innerUDFNode.attributeValue("outCounter")));
            this.parseUDF(innerUDF, innerUDFNode);
            innerUDF.changeNumber(udfNumber);
            udfBlock.add(innerUDF);
        }
        this.parseChildernWithoutNesting(udfBlock, blocksNode);
        this.parseUDFParameter(udfBlock, outerUDFBlockNode);
    }

    protected void parseUDFParameter(UDFBlock udfBlock, Element udfNode) {
        UDFBlockParameter udfParam = (UDFBlockParameter)udfBlock.getParameter();
        udfBlock.setIdentifier(udfNode.attributeValue("identifier"));
        udfBlock.setComment(udfNode.attributeValue("comments"));
        udfBlock.setValidity(Integer.valueOf(udfNode.attributeValue("validity")));
        Iterator guidsIterator = udfNode.element("GuidList").elementIterator("Guid");
        while (guidsIterator.hasNext()) {
            Element guidNode = (Element)guidsIterator.next();
            String version = guidNode.attributeValue("version");
            long guid = Long.valueOf(guidNode.attributeValue("value"));
            udfBlock.getGuidManager().addGuid(version, guid);
        }
        Iterator udfParamItems = udfNode.element("Parameter").elementIterator();
        ParameterItemIdentifierTableLogo7 identifierTable = (ParameterItemIdentifierTableLogo7)this.fHardware.getProperty("parameterItemIdentifierTable");
        while (udfParamItems.hasNext()) {
            Element paramItem = (Element)udfParamItems.next();
            int opcode = Integer.valueOf(paramItem.attributeValue("opcode"));
            int blockNumber = Integer.valueOf(paramItem.attributeValue("blockNumber"));
            Block block = ((Logo7)this.fWiringDiagram.getHardware()).getUDFRelatedOpcode("UDF") == opcode ? this.getUDFBlock(blockNumber, -1, -1) : this.getBlock(opcode, blockNumber);
            String orginalParamIdentifier = identifierTable.getOrigIdentifier(block.getParameter(), paramItem.getName());
            udfParam.addItem(paramItem.attributeValue("name"), block, orginalParamIdentifier);
        }
    }

    protected void parseChildernWithoutNesting(UDFBlock udfBlock, Element udfBlocksNode) {
        Block block;
        Element blockNode;
        Iterator inIterator = udfBlocksNode.element("InGroup").elementIterator();
        int index = 0;
        while (inIterator.hasNext()) {
            blockNode = (Element)inIterator.next();
            int opcode = Integer.valueOf(blockNode.attributeValue("opcode"));
            int blockNumber = Integer.valueOf(blockNode.attributeValue("blockNumber"));
            if (((Logo7)this.fWiringDiagram.getHardware()).getUDFRelatedOpcode("Deputy") == opcode) {
                block = this.getDeputyBlock(index++, blockNumber, udfBlock);
                block.setWiringDiagram(this.fWiringDiagram);
            } else {
                block = this.getBlock(opcode, blockNumber);
                ((WiringDiagramUDF)block.getWiringDiagram()).getInConnectorBlocks().add(block);
            }
            this.acceptVisitor(block, blockNode);
        }
        Iterator outIterator = udfBlocksNode.element("OutGroup").elementIterator();
        index = 0;
        while (outIterator.hasNext()) {
            blockNode = (Element)outIterator.next();
            int opcode = Integer.valueOf(blockNode.attributeValue("opcode"));
            int blockNumber = Integer.valueOf(blockNode.attributeValue("blockNumber"));
            if (((Logo7)this.fWiringDiagram.getHardware()).getUDFRelatedOpcode("Deputy") == opcode) {
                block = this.getDeputyBlock(index++, blockNumber, udfBlock);
                block.setWiringDiagram(this.fWiringDiagram);
            } else {
                block = this.getBlock(opcode, blockNumber);
                ((WiringDiagramUDF)block.getWiringDiagram()).getOutConnectorBlocks().add(block);
            }
            this.acceptVisitor(block, blockNode);
        }
        Iterator blocksIterator = udfBlocksNode.elementIterator("Block");
        while (blocksIterator.hasNext()) {
            blockNode = (Element)blocksIterator.next();
            int opcode = Integer.valueOf(blockNode.attributeValue("opcode"));
            int blockNumber = Integer.valueOf(blockNode.attributeValue("blockNumber"));
            block = this.getBlock(opcode, blockNumber);
            udfBlock.add(block);
            this.acceptVisitor(block, blockNode);
        }
    }

    protected void acceptVisitor(Block block, Element blockNode) {
        ElementCodeBlock codeBlock = new ElementCodeBlock(this, "visit");
        codeBlock.addParameter(block);
        codeBlock.addParameter(blockNode);
        try {
            codeBlock.execMethod();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchMethodError();
        }
    }

    private UDFBlock getUDFBlock(int blockNumber, int inCount, int outCount) {
        UDFBlock result = (UDFBlock)this.fUDFStorer.get(blockNumber);
        if (result != null) {
            return result;
        }
        result = new UDFBlock(this.fWiringDiagram, inCount + 1, outCount);
        result.changeNumber(blockNumber);
        this.fUDFStorer.put(blockNumber, result);
        return result;
    }

    private DeputyBlock getDeputyBlock(int index, int blockNumber, UDFBlock parent) {
        int number = blockNumber & 0x3F;
        int adType = (blockNumber & 0x40) >> 6;
        boolean isInputType = (blockNumber & 0x80) >> 7 == 0;
        DeputyBlock[] deputyBlocks = isInputType ? parent.getInputDeputies() : parent.getOutputDeputies();
        for (int i = 0; i < deputyBlocks.length; ++i) {
            if (deputyBlocks[i] == null || adType != deputyBlocks[i].getBinaryAnalogType() || number != deputyBlocks[i].getNumber()) continue;
            return deputyBlocks[i];
        }
        DeputyBlock deputy = new DeputyBlock();
        deputy.setBinaryAnalogType(adType);
        deputy.setNumber(number);
        deputy.setInputType(isInputType);
        deputy.setParent(parent);
        if (isInputType) {
            parent.setInputDeputy(index, deputy);
        } else {
            parent.setOutputDeputy(index, deputy);
        }
        return deputy;
    }

    protected void connect(Block source, Element blockNode) {
        Iterator connectorsNode = blockNode.elementIterator("InConnector");
        while (connectorsNode.hasNext()) {
            Block target;
            int opcode;
            Element connectorNode = (Element)connectorsNode.next();
            InBlockConnector inConnector = source.getInConnector(Integer.valueOf(connectorNode.attributeValue("index")));
            if (inConnector.getSignalType() != 1) {
                inConnector.setNegated(Boolean.valueOf(connectorNode.attributeValue("negate")));
            }
            if ((opcode = Integer.valueOf(connectorNode.attributeValue("opcode")).intValue()) == Integer.valueOf("255")) continue;
            int blockNumber = Integer.valueOf(connectorNode.attributeValue("blockNumber"));
            if (((Logo7)this.fWiringDiagram.getHardware()).getUDFRelatedOpcode("Deputy") == opcode) {
                int parentNumber = Integer.valueOf(connectorNode.attributeValue("parent"));
                int inCount = Integer.valueOf(connectorNode.attributeValue("inCounter"));
                int outCount = Integer.valueOf(connectorNode.attributeValue("outCounter"));
                int index = Integer.valueOf(connectorNode.attributeValue("parentIndex"));
                UDFBlock parent = this.getUDFBlock(parentNumber, inCount, outCount);
                target = this.getDeputyBlock(index, blockNumber, parent);
            } else {
                target = this.getBlock(opcode, blockNumber);
            }
            OutBlockConnector outConnector = target.getOutConnector(0);
            inConnector.connect(outConnector);
        }
    }

    public void visit(DeputyBlock block, Element blockNode) {
        block.setUserDefinedName(blockNode.attributeValue("name"));
        this.connect(block, blockNode);
    }

    protected void loadProperties(WiringDiagram wd, Element root) {
        Element propertiesNode = root.element("Properties");
        DrawingProperties dp = wd.getDrawingProperties();
        dp.setCreator(propertiesNode.element("Creator").getText());
        dp.setProjectname(propertiesNode.element("Projectname").getText());
        dp.setInstallationname(propertiesNode.element("Installationname").getText());
        dp.setCustomer(propertiesNode.element("Customer").getText());
        dp.setDiagramnr(propertiesNode.element("Diagramno").getText());
        dp.setChecked(propertiesNode.element("Checked").getText());
        dp.setCompany(propertiesNode.element("Company").getText());
        dp.setVersion(propertiesNode.element("Version").getText());
        dp.setShowDialogAtNewFile(Boolean.valueOf(propertiesNode.element("Show").getText()));
        dp.setComment(propertiesNode.element("Comments").getText());
        dp.setPagesHorizontal(Integer.valueOf(propertiesNode.element("Horizontal").getText()));
        dp.setPagesVertical(Integer.valueOf(propertiesNode.element("Vertical").getText()));
        Element historyNode = propertiesNode.element("History");
        Iterator displayedIT = historyNode.elementIterator("DisplayedHistory");
        Element historyItem = null;
        DrawingHistoryEntry dhe = null;
        ArrayList<DrawingHistoryEntry> displayedlist = new ArrayList<DrawingHistoryEntry>();
        while (displayedIT.hasNext()) {
            dhe = new DrawingHistoryEntry();
            historyItem = (Element)displayedIT.next();
            if (historyItem.elements().size() < 1) continue;
            dhe.setChangeDate(new Date(Long.valueOf(historyItem.element("Date").getText())));
            dhe.setUser(historyItem.element("User").getText());
            dhe.setSoftwareVersion(new Version(historyItem.element("Version").getText()));
            dhe.setChangeComment(historyItem.element("Comments").getText());
            dhe.setSaved(Boolean.valueOf(historyItem.element("Saved").getText()));
            displayedlist.add(dhe);
        }
        dp.setDrawingHistory(displayedlist);
        ArrayList<DrawingHistoryEntry> deletedlist = new ArrayList<DrawingHistoryEntry>();
        Iterator deletedIT = historyNode.elementIterator("DeletedHistory");
        while (deletedIT.hasNext()) {
            dhe = new DrawingHistoryEntry();
            historyItem = (Element)deletedIT.next();
            if (historyItem.elements().size() < 1) continue;
            dhe.setChangeDate(new Date(Long.valueOf(historyItem.element("Date").getText())));
            dhe.setUser(historyItem.element("User").getText());
            dhe.setSoftwareVersion(new Version(historyItem.element("Version").getText()));
            dhe.setChangeComment(historyItem.element("Comments").getText());
            dhe.setDeleted(Boolean.valueOf(historyItem.element("Deleted").getText()));
            deletedlist.add(dhe);
        }
        dp.setDeletedHistory(deletedlist);
        Element paperformatNode = propertiesNode.element("PageFormat");
        Element marginNode = paperformatNode.element("Margin");
        double paperMarginX = Double.valueOf(marginNode.element("Left").getText());
        double paperMarginY = Double.valueOf(marginNode.element("Top").getText());
        Element paperImageNode = paperformatNode.element("Imagesize");
        double paperImageWidth = Double.valueOf(paperImageNode.element("Width").getText());
        double paperImageHeight = Double.valueOf(paperImageNode.element("Height").getText());
        Element paperNode = paperformatNode.element("Paper");
        double paperWidth = Double.valueOf(paperNode.element("Width").getText());
        double paperHeight = Double.valueOf(paperNode.element("Height").getText());
        int pageOrientation = Integer.valueOf(paperformatNode.element("Orientation").getText());
        Paper paper = new Paper();
        paper.setImageableArea(paperMarginX, paperMarginY, paperImageWidth, paperImageHeight);
        paper.setSize(paperWidth, paperHeight);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(pageOrientation);
        pageFormat.setPaper(paper);
        String cipherTxt = propertiesNode.element("Password").getText();
        ((WiringDiagramUDF)this.fWiringDiagram).getUDFBlock().setEncryptedPassword(cipherTxt);
        this.decryptUDFPassword(((WiringDiagramUDF)this.fWiringDiagram).getUDFBlock());
    }

    private void decryptUDFPassword(UDFBlock block) {
        int checksumNow = this.fHardware.getChecksum(this.fWiringDiagram);
        String cipher = EncryptAndDecrypt.decrypt(block.getEncryptedPassword(), String.valueOf(checksumNow));
        if (cipher.length() < 2) {
            block.setPasswordDestroyed(true);
            return;
        }
        try {
            Integer.parseInt(cipher.substring(0, 2));
        }
        catch (NumberFormatException e) {
            block.setPasswordDestroyed(true);
            return;
        }
        int checksumLength = Integer.parseInt(cipher.substring(0, 2));
        if (checksumLength > cipher.length() - 2 || !String.valueOf(checksumNow).equals(cipher.substring(2, checksumLength + 2))) {
            block.setPasswordDestroyed(true);
            return;
        }
        block.setPassword(cipher.substring(checksumLength + 2));
    }
}

